/*
Blink version francisée
Allume une LED pendant une seconde, puis l’éteint
pendant une seconde, de façon répétitive.
La plupart des cartes Arduino possèdent une LED intégrée
que tu peux contrôler. Sur la Uno et la Leonardo, elle
est reliée à la broche numérique 13.
Si tu n’es pas sûr de la broche à laquelle la LED est
reliée, vérifie la documentation de ta carte sur le site
http://arduino.cc.
Cet exemple de programme est dans le domaine public.
Modifié le 8 May 2014
par Scott Fitzgerald
*/
/*
  Blink
  Turns on an LED on for one second, then off for one second, repeatedly.

  Most Arduinos have an on-board LED you can control. On the Uno and
  Leonardo, it is attached to digital pin 13. If you're unsure what
  pin the on-board LED is connected to on your Arduino model, check
  the documentation at http://arduino.cc

  This example code is in the public domain.

  modified 8 May 2014
  by Scott Fitzgerald
 */

/* La fonction setup est exécutée quand tu
appuies sur le bouton reset ou alimente la
carte. */
void setup() {
  // initialise la broche 13 en mode sortie
  pinMode(13, OUTPUT);
}

/* La fonction loop s’exécute de façon
répétitive */
void loop() {
  digitalWrite(13, HIGH); /* allume la LED
  (HIGH est le niveau de tension HAUT) */
  delay(1000); // pause d’une seconde
  digitalWrite(13, LOW); /* éteint la LED en
  mettant le niveau de sortie BAS (LOW)*/
  delay(1000); // pause d’une seconde
}
